// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/devices_app/usb/public/interfaces/permission_provider.mojom
//

package org.chromium.mojom.device.usb;

class PermissionProvider_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<PermissionProvider, PermissionProvider.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<PermissionProvider, PermissionProvider.Proxy>() {
    
        public String getName() {
            return "device::usb::PermissionProvider";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, PermissionProvider impl) {
            return new Stub(core, impl);
        }
    
        public PermissionProvider[] buildArray(int size) {
          return new PermissionProvider[size];
        }
    };

    private static final int HAS_DEVICE_PERMISSION_ORDINAL = 0;
    private static final int HAS_CONFIGURATION_PERMISSION_ORDINAL = 1;
    private static final int HAS_INTERFACE_PERMISSION_ORDINAL = 2;
    private static final int BIND_ORDINAL = 3;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements PermissionProvider.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void hasDevicePermission(DeviceInfo[] requestedDevices, HasDevicePermissionResponse callback) {
            PermissionProviderHasDevicePermissionParams _message = new PermissionProviderHasDevicePermissionParams();
            _message.requestedDevices = requestedDevices;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    HAS_DEVICE_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PermissionProviderHasDevicePermissionResponseParamsForwardToCallback(callback));
        }

        @Override
        public void hasConfigurationPermission(byte requestedConfiguration, DeviceInfo device, HasConfigurationPermissionResponse callback) {
            PermissionProviderHasConfigurationPermissionParams _message = new PermissionProviderHasConfigurationPermissionParams();
            _message.requestedConfiguration = requestedConfiguration;
            _message.device = device;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    HAS_CONFIGURATION_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PermissionProviderHasConfigurationPermissionResponseParamsForwardToCallback(callback));
        }

        @Override
        public void hasInterfacePermission(byte requestedInterface, byte configurationValue, DeviceInfo device, HasInterfacePermissionResponse callback) {
            PermissionProviderHasInterfacePermissionParams _message = new PermissionProviderHasInterfacePermissionParams();
            _message.requestedInterface = requestedInterface;
            _message.configurationValue = configurationValue;
            _message.device = device;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    HAS_INTERFACE_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PermissionProviderHasInterfacePermissionResponseParamsForwardToCallback(callback));
        }

        @Override
        public void bind(org.chromium.mojo.bindings.InterfaceRequest<PermissionProvider> request) {
            PermissionProviderBindParams _message = new PermissionProviderBindParams();
            _message.request = request;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(BIND_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<PermissionProvider> {

        Stub(org.chromium.mojo.system.Core core, PermissionProvider impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PermissionProvider_Internal.MANAGER, messageWithHeader);
                    case BIND_ORDINAL: {
                        PermissionProviderBindParams data =
                                PermissionProviderBindParams.deserialize(messageWithHeader.getPayload());
                        getImpl().bind(data.request);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PermissionProvider_Internal.MANAGER, messageWithHeader, receiver);
                    case HAS_DEVICE_PERMISSION_ORDINAL: {
                        PermissionProviderHasDevicePermissionParams data =
                                PermissionProviderHasDevicePermissionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().hasDevicePermission(data.requestedDevices, new PermissionProviderHasDevicePermissionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case HAS_CONFIGURATION_PERMISSION_ORDINAL: {
                        PermissionProviderHasConfigurationPermissionParams data =
                                PermissionProviderHasConfigurationPermissionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().hasConfigurationPermission(data.requestedConfiguration, data.device, new PermissionProviderHasConfigurationPermissionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case HAS_INTERFACE_PERMISSION_ORDINAL: {
                        PermissionProviderHasInterfacePermissionParams data =
                                PermissionProviderHasInterfacePermissionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().hasInterfacePermission(data.requestedInterface, data.configurationValue, data.device, new PermissionProviderHasInterfacePermissionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class PermissionProviderHasDevicePermissionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public DeviceInfo[] requestedDevices;
    
        private PermissionProviderHasDevicePermissionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionProviderHasDevicePermissionParams() {
            this(0);
        }
    
        public static PermissionProviderHasDevicePermissionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionProviderHasDevicePermissionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionProviderHasDevicePermissionParams result = new PermissionProviderHasDevicePermissionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.requestedDevices = new DeviceInfo[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.requestedDevices[i1] = DeviceInfo.decode(decoder2);
                    }
                }
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            if (requestedDevices == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(requestedDevices.length, 8, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < requestedDevices.length; ++i0) {
                    encoder1.encode(requestedDevices[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionProviderHasDevicePermissionParams other = (PermissionProviderHasDevicePermissionParams) object;
            if (!java.util.Arrays.deepEquals(this.requestedDevices, other.requestedDevices))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + java.util.Arrays.deepHashCode(requestedDevices);
            return result;
        }
    }

    static final class PermissionProviderHasDevicePermissionResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String[] allowedGuids;
    
        private PermissionProviderHasDevicePermissionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionProviderHasDevicePermissionResponseParams() {
            this(0);
        }
    
        public static PermissionProviderHasDevicePermissionResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionProviderHasDevicePermissionResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionProviderHasDevicePermissionResponseParams result = new PermissionProviderHasDevicePermissionResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.allowedGuids = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        result.allowedGuids[i1] = decoder1.readString(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            if (allowedGuids == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(allowedGuids.length, 8, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < allowedGuids.length; ++i0) {
                    encoder1.encode(allowedGuids[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionProviderHasDevicePermissionResponseParams other = (PermissionProviderHasDevicePermissionResponseParams) object;
            if (!java.util.Arrays.deepEquals(this.allowedGuids, other.allowedGuids))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + java.util.Arrays.deepHashCode(allowedGuids);
            return result;
        }
    }

    static class PermissionProviderHasDevicePermissionResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PermissionProvider.HasDevicePermissionResponse mCallback;

        PermissionProviderHasDevicePermissionResponseParamsForwardToCallback(PermissionProvider.HasDevicePermissionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(HAS_DEVICE_PERMISSION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PermissionProviderHasDevicePermissionResponseParams response = PermissionProviderHasDevicePermissionResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.allowedGuids);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PermissionProviderHasDevicePermissionResponseParamsProxyToResponder implements PermissionProvider.HasDevicePermissionResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PermissionProviderHasDevicePermissionResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(String[] allowedGuids) {
            PermissionProviderHasDevicePermissionResponseParams _response = new PermissionProviderHasDevicePermissionResponseParams();
            _response.allowedGuids = allowedGuids;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    HAS_DEVICE_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PermissionProviderHasConfigurationPermissionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public byte requestedConfiguration;
        public DeviceInfo device;
    
        private PermissionProviderHasConfigurationPermissionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionProviderHasConfigurationPermissionParams() {
            this(0);
        }
    
        public static PermissionProviderHasConfigurationPermissionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionProviderHasConfigurationPermissionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionProviderHasConfigurationPermissionParams result = new PermissionProviderHasConfigurationPermissionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.requestedConfiguration = decoder0.readByte(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.device = DeviceInfo.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(requestedConfiguration, 8);
            encoder0.encode(device, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionProviderHasConfigurationPermissionParams other = (PermissionProviderHasConfigurationPermissionParams) object;
            if (this.requestedConfiguration != other.requestedConfiguration)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.device, other.device))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(requestedConfiguration);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(device);
            return result;
        }
    }

    static final class PermissionProviderHasConfigurationPermissionResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean allowed;
    
        private PermissionProviderHasConfigurationPermissionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionProviderHasConfigurationPermissionResponseParams() {
            this(0);
        }
    
        public static PermissionProviderHasConfigurationPermissionResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionProviderHasConfigurationPermissionResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionProviderHasConfigurationPermissionResponseParams result = new PermissionProviderHasConfigurationPermissionResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.allowed = decoder0.readBoolean(8, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(allowed, 8, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionProviderHasConfigurationPermissionResponseParams other = (PermissionProviderHasConfigurationPermissionResponseParams) object;
            if (this.allowed != other.allowed)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(allowed);
            return result;
        }
    }

    static class PermissionProviderHasConfigurationPermissionResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PermissionProvider.HasConfigurationPermissionResponse mCallback;

        PermissionProviderHasConfigurationPermissionResponseParamsForwardToCallback(PermissionProvider.HasConfigurationPermissionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(HAS_CONFIGURATION_PERMISSION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PermissionProviderHasConfigurationPermissionResponseParams response = PermissionProviderHasConfigurationPermissionResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.allowed);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PermissionProviderHasConfigurationPermissionResponseParamsProxyToResponder implements PermissionProvider.HasConfigurationPermissionResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PermissionProviderHasConfigurationPermissionResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean allowed) {
            PermissionProviderHasConfigurationPermissionResponseParams _response = new PermissionProviderHasConfigurationPermissionResponseParams();
            _response.allowed = allowed;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    HAS_CONFIGURATION_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PermissionProviderHasInterfacePermissionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public byte requestedInterface;
        public byte configurationValue;
        public DeviceInfo device;
    
        private PermissionProviderHasInterfacePermissionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionProviderHasInterfacePermissionParams() {
            this(0);
        }
    
        public static PermissionProviderHasInterfacePermissionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionProviderHasInterfacePermissionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionProviderHasInterfacePermissionParams result = new PermissionProviderHasInterfacePermissionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.requestedInterface = decoder0.readByte(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.configurationValue = decoder0.readByte(9);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.device = DeviceInfo.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(requestedInterface, 8);
            encoder0.encode(configurationValue, 9);
            encoder0.encode(device, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionProviderHasInterfacePermissionParams other = (PermissionProviderHasInterfacePermissionParams) object;
            if (this.requestedInterface != other.requestedInterface)
                return false;
            if (this.configurationValue != other.configurationValue)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.device, other.device))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(requestedInterface);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(configurationValue);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(device);
            return result;
        }
    }

    static final class PermissionProviderHasInterfacePermissionResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean allowed;
    
        private PermissionProviderHasInterfacePermissionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionProviderHasInterfacePermissionResponseParams() {
            this(0);
        }
    
        public static PermissionProviderHasInterfacePermissionResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionProviderHasInterfacePermissionResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionProviderHasInterfacePermissionResponseParams result = new PermissionProviderHasInterfacePermissionResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.allowed = decoder0.readBoolean(8, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(allowed, 8, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionProviderHasInterfacePermissionResponseParams other = (PermissionProviderHasInterfacePermissionResponseParams) object;
            if (this.allowed != other.allowed)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(allowed);
            return result;
        }
    }

    static class PermissionProviderHasInterfacePermissionResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PermissionProvider.HasInterfacePermissionResponse mCallback;

        PermissionProviderHasInterfacePermissionResponseParamsForwardToCallback(PermissionProvider.HasInterfacePermissionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(HAS_INTERFACE_PERMISSION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PermissionProviderHasInterfacePermissionResponseParams response = PermissionProviderHasInterfacePermissionResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.allowed);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PermissionProviderHasInterfacePermissionResponseParamsProxyToResponder implements PermissionProvider.HasInterfacePermissionResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PermissionProviderHasInterfacePermissionResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean allowed) {
            PermissionProviderHasInterfacePermissionResponseParams _response = new PermissionProviderHasInterfacePermissionResponseParams();
            _response.allowed = allowed;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    HAS_INTERFACE_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PermissionProviderBindParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public org.chromium.mojo.bindings.InterfaceRequest<PermissionProvider> request;
    
        private PermissionProviderBindParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionProviderBindParams() {
            this(0);
        }
    
        public static PermissionProviderBindParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionProviderBindParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionProviderBindParams result = new PermissionProviderBindParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.request = decoder0.readInterfaceRequest(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(request, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionProviderBindParams other = (PermissionProviderBindParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.request, other.request))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(request);
            return result;
        }
    }

}

